/**
 * $Author: ischmidtLSS $ -- $Date: 2005/05/16 09:45:35 $ -- $Version: $ 
 */

//
//  ISP_LssView.h
//  LiquidScatterSpace
//
//  Created by Iven Schmidt on 16.12.04.
//  Copyright 2004 www.infoverse.org and Iven Schmidt. 
//	All rights reserved.
//

/*************************************************************
* Class ISP_LssView											 *
* inherits from NSView and provides the Liquid Scatter Space *
*															 *
* It responds to mouse and key events.						 *
* It displays the data.										 *
**************************************************************/

#import <Cocoa/Cocoa.h>
#import <CoreFoundation/CoreFoundation.h>

@class ISP_File;

@interface ISP_LssView : NSView {

	// helper array for precalculation of gauss values
	NSMutableArray *gauss; 
	
	// the object wich contains the data array
	// to be connected in interface builder
	id dataSource;
	
	// helpers for different purposes
	BOOL setNearest;
	BOOL copy;
	BOOL lock;
	BOOL selection;
	BOOL penMoving;
	BOOL moveYAxis;
	float yAxisAdjustmentFactor;
	NSTimer *renderTimer;
	
	// drawing and mouse events
	NSRect	lastbounds;
	float	labelOpacity;

	NSColor *highlightColor;
	
	double	lastMove;
	BOOL	mouseOverLSS;
	
	double magnet;

	NSTrackingRectTag trackingRectTag;
	NSPoint currentPoint;
	NSPoint downPoint;
	NSPoint mouseCoordinates;
	
	NSMutableDictionary *attribsDict;
	NSMutableDictionary *attribsDictHighlighted;
	NSMutableDictionary *attribsDictNearest;
	NSMutableDictionary *attribsDictXAxisLabels;
}

// drawing subroutines
- (void)drawDots;
- (void)drawAxes;
- (void)drawMouseLocationPointer;
- (void)drawYAxisGrabber;
- (void)drawWhiteOverlay;
- (void)drawSizeForNearestInBottomLeftCorner;

// helper methods for drawing and mouse events
- (NSPoint)checkIfMouseCoordinatesWithinLSSBounds;
- (void)adjustPositionOfYAxis;
- (int)checkIfYAxisPositionWithinBorderBounds:(int)l_position;
- (void)setAttribsDict:(int)l_fontSize;
- (void)setAttribsDictHighlighted:(int)l_fontSize;
- (void)setAttribsDictNearest:(int)l_fontSize;
- (void)setAttribsDictXAxisLabels:(int)l_fontSize;
- (NSColor *)getColorForDot:(ISP_File *)l_dot;
- (NSColor *)getColorForName:(ISP_File *)l_dot;
- (NSRect)makeDotRect:(ISP_File *)l_dot;
- (NSString *)sizeAsString:(int)l_size;
- (NSRect)selectionRect;
- (void)setMagnet:(float)l_magnet;
- (void)setLabelOpacity:(float)l_opacity;

// updating the dots
- (void)move;
- (void)calculateLiquidPositionForDot:(ISP_File *)l_dot;
- (void)lock;

// drag'n'drop
- (void)writeFileToPasteboard:(NSPasteboard *)pboard event:(NSEvent *)e;

// liquid timer
- (void)startTimer;
- (void)stopTimer;

@end

/*
 * $Log: ISP_LssView.h,v $
 * Revision 1.15  2005/05/16 09:45:35  ischmidtLSS
 * cleanup
 *
 * Revision 1.14  2005/05/16 07:31:59  ischmidtLSS
 * pressure removed
 *
 * Revision 1.13  2005/05/05 17:49:07  ischmidtLSS
 * added highlight color
 *
 * Revision 1.12  2005/05/05 16:13:12  ischmidtLSS
 * added drawYAxisGrabber
 *
 * Revision 1.11  2005/04/29 15:33:15  ischmidtLSS
 * improved drawing of axes and lettering
added drawing of filesize
 *
 * Revision 1.10  2005/04/29 14:11:33  ischmidtLSS
 * getColorForDot and getColorForName separated
 *
 * Revision 1.9  2005/04/24 14:05:06  ischmidtLSS
 * added rendering with NSTimer
 *
 * Revision 1.8  2005/04/22 14:06:56  ischmidtLSS
 * added renderTimer
 *
 * Revision 1.7  2005/04/11 14:08:19  ischmidtLSS
 * added CVS version tags in class files
 *
 */