//
//  ISP_DataRepresentation.h
//  LiquidScatterSpace
//
//  Created by Iven Schmidt on 07.01.05.
//  Copyright 2005 www.infoverse.org and Iven Schmidt. 
//	All rights reserved.
//

/*************************************************************
* Class ISP_DataRepresentation								 *
*															 *
* reads the filesystem and represents the contents in an	 *
* array of ISP_File objects									 *
**************************************************************/

#import <Cocoa/Cocoa.h>


@interface ISP_DataRepresentation : NSObject {
	
	NSMutableArray			*fileArray;
	
	BOOL					refresh;
	double					lastRead;
}

- (void)fileArray;
- (void)fileArrayByNameFilter:(NSString *)l_string;
- (void)fileArrayBySelection:(BOOL)l_selection;
- (NSMutableArray *)fileArrayByNameFilter:(NSString *)l_string selection:(BOOL)l_selection;

- (NSMutableArray *)filterArrayBySelection:(NSMutableArray *)fa;
- (NSMutableArray *)filterArray:(NSMutableArray *)fa byString:(NSString *)l_string;

//- (void)setDir:(NSString *)l_dir;
- (void)readDirectory:(NSString *)l_dir 
   withSubdirectories:(BOOL)l_sub
	   withInvisibles:(BOOL)l_inv 
		  withFolders:(BOOL)l_fol;


@end

/*
 * $Log: ISP_DataRepresentation.h,v $
 * Revision 1.3  2005/05/16 09:42:16  ischmidtLSS
 * added filtering by multiple strings separated by " "
 *
 * Revision 1.2  2005/04/11 14:08:19  ischmidtLSS
 * added CVS version tags in class files
 *
 */