//
//  ISP_File.h
//  LiquidScatterSpace
//
//  Created by Iven Schmidt on 16.12.04.
//  Copyright 2004 www.infoverse.org and Iven Schmidt. 
//	All rights reserved.
//

/*************************************************************
* Class ISP_File											 *
*															 *
* Represents files as model objects.						 *
**************************************************************/

#import <Cocoa/Cocoa.h>


@interface ISP_File : NSObject {
	
	// position
	float x;
	float y;
	float orig_x;
	float orig_y;
	float force_x;
	float force_y;
	BOOL  selected;
	BOOL  nearest;
	float drawSize;
	
	// file parameters
	NSNumber *size;
	NSString *name;
	NSString *suffix;
	NSString *HFSType;
	NSDate	 *created;
	NSDate	 *changed;
	NSString *owner;
	NSString *path;
	NSImage	 *image;
}

// position accessors
- (float)x;
- (void)setX:(float)l_x;
- (float)y;
- (void)setY:(float)l_y;
- (float)orig_x;
- (void)setOrig_x:(float)l_orig_x;
- (float)orig_y;
- (void)setOrig_y:(float)l_orig_y;
- (float)force_x;
- (void)setForce_x:(float)l_force_x;
- (float)force_y;
- (void)setForce_y:(float)l_force_y;
- (BOOL)selected;
- (void)setSelected:(BOOL)l_selected;
- (void)toggleSelection;
- (BOOL)nearest;
- (void)setNearest:(BOOL)l_nearest;
- (float)drawingSize;
- (void)setDrawingSize:(float)l_drawSize;

// file parameter accessors
- (NSNumber *)size;
- (void)setSize:(NSNumber *)l_size;
- (NSString *)sizeAsString;
- (NSString *)name;
- (void)setName:(NSString *)l_name;
- (NSString *)suffix;
- (void)setSuffix:(NSString *)l_suffix;
- (NSString *)HFSType;
- (void)setHFSType:(NSString *)l_HFSType;
- (NSDate *)created;
- (NSString *)createdAsString;
- (void)setCreated:(NSDate *)l_created;
- (NSDate *)changed;
- (NSString *)changedAsString;
- (void)setChanged:(NSDate *)l_changed;
- (NSString *)owner;
- (void)setOwner:(NSString *)l_owner;
- (NSString *)path;
- (void)setPath:(NSString *)l_path;
- (NSImage *)image;
- (void)setImage:(NSImage *)l_image;

@end

/*
 * $Log: ISP_File.h,v $
 * Revision 1.2  2005/04/11 14:08:19  ischmidtLSS
 * added CVS version tags in class files
 *
 */