//
//  ISP_DocumentController.h
//  LiquidScatterSpace
//
//  Created by Iven Schmidt on 27.12.04.
//  Copyright 2004 www.infoverse.org and Iven Schmidt. 
//	All rights reserved.
//

/*************************************************************
* Class ISP_DocumentController								 *
* overrides NSDocumentController for modified opening and	 *
* other modified behaviour									 *
*															 *
* ISP does not open data representations of files			 *
* Instead ISP_DC [self] just selects a folder to read in	 *
**************************************************************/

#import <Cocoa/Cocoa.h>

@class ISP_PreferenceController;

@interface ISP_DocumentController : NSDocumentController {
	
	ISP_PreferenceController *preferenceController;
}

// modified opening
- (IBAction)openDocument:(id)sender;

// actions for settings windows/panels
- (IBAction)showPreferencePanel:(id)sender;
- (IBAction)showDisplayPreferencePanel:(id)sender;
- (IBAction)showFileInfoPanel:(id)sender;
- (IBAction)showViewPreferenceDrawer:(id)sender;

// scatter space actions
- (IBAction)selectAll:(id)sender;
- (IBAction)filterBySelection:(id)sender;
- (IBAction)resetSelectionFilter:(id)sender;

@end

/*
 * $Log: ISP_DocumentController.h,v $
 * Revision 1.6  2005/05/16 09:42:52  ischmidtLSS
 * removed zoom
 *
 * Revision 1.5  2005/05/05 14:51:04  ischmidtLSS
 * lock removed
 *
 * Revision 1.4  2005/04/22 14:05:21  ischmidtLSS
 * added "show drawer"
 *
 * Revision 1.3  2005/04/11 14:08:19  ischmidtLSS
 * added CVS version tags in class files
 *
 */