//
//  ISP_Defaults.h
//  LiquidScatterSpace
//
//  Created by Iven Schmidt on 16.12.04.
//  Copyright 2004 www.infoverse.org and Iven Schmidt. 
//	All rights reserved.
//

/***************************************************************
 * Class ISP_Defaults										   *
 * sets development defaults and constants					   *
 *															   *
 * the constants are not only for development, they are also   *
 * for later runtime										   *
 *															   *
 * ISP_Defaults.h must be imported in all implementation files *
 ***************************************************************/

#import <Cocoa/Cocoa.h>

/* 
 * development defaults 
 * 
 * 0 = off, 1 = on
 * -> should be off for deployment builds
 */

// debug - switches debug loggging on/off
#define DEBUG 1	

// generally precalculated - live calculation removed
// gauss - switches live calculation of gauss-algorithm on/off
// may help older hardware
// #define GAUSS 1

/*
 * constants
 */

// magnet = power of liquid reaction
//
// magnet for mouse
#define ISP_FIXED_MAGNET_0 0.0
#define ISP_FIXED_MAGNET_1 0.03
#define ISP_FIXED_MAGNET_2 0.05
#define ISP_FIXED_MAGNET_3 0.08

// margins for drawing
#define ISP_MARGIN_L 110.0 
/* margin_l is default x value for y-axis */
#define ISP_MARGIN_R 10.0
#define ISP_MARGIN_B 15.0
#define ISP_MARGIN_T 10.0

// y-axis positioning
#define ISP_YAXIS_BORDER_LEFT 60
#define ISP_YAXIS_BORDER_RIGHT 50
extern int ISP_yAxis_xValue;

// fixed label opacities
//#define ISP_FIXED_LABEL_OPAC_0 0.0
#define ISP_FIXED_LABEL_OPAC_1 0.15
#define ISP_FIXED_LABEL_OPAC_2 0.20
#define ISP_FIXED_LABEL_OPAC_3 0.25
#define ISP_FIXED_LABEL_OPAC_4 0.30
#define ISP_FIXED_LABEL_OPAC_5 0.35

// active radius for liquid reaction
#define ISP_RADIUS 35.0						

// level of attenuation for liquid reaction
#define ISP_ATTENUATION	1.2					

// leven of oscillation/vibration for liquid reaction
#define ISP_OSCILLATION	30.0				

// text output settings
#define ISP_DISPLAY_FONT_SIZE_BASE 9
#define ISP_DISPLAY_FONT_SIZE_MIN 2
#define ISP_DISPLAY_FONT_SIZE_HIGHLIGHT 12
#define ISP_DISPLAY_LINE_SPACE_BASE 1
//extern float ISP_displayFontSize;
extern float ISP_highlightFontSize;
extern float ISP_displayLineSpace;


@interface ISP_Defaults : NSObject {

}

@end

/*
 * $Log: ISP_Defaults.h,v $
 * Revision 1.17  2005/05/26 09:16:15  ischmidtLSS
 * use only highlightFontSize
 *
 * Revision 1.16  2005/05/16 09:42:38  ischmidtLSS
 * *** empty log message ***
 *
 * Revision 1.15  2005/05/05 17:48:11  ischmidtLSS
 * adjustments of default values
 *
 * Revision 1.14  2005/05/05 14:50:50  ischmidtLSS
 * scatter space is now more narrow
 *
 * Revision 1.13  2005/04/29 15:32:02  ischmidtLSS
 * reduced bottom margin
 *
 * Revision 1.12  2005/04/29 14:10:52  ischmidtLSS
 * left margin is more on the right to give more space to names
 *
 * Revision 1.11  2005/04/28 10:31:57  ischmidtLSS
 * added min_tex_size
 *
 * Revision 1.10  2005/04/24 14:02:29  ischmidtLSS
 * added ISP_highlightFontSize
 *
 * Revision 1.9  2005/04/22 14:05:00  ischmidtLSS
 * changed fontSize to type float
 *
 * Revision 1.8  2005/04/11 14:08:19  ischmidtLSS
 * added CVS version tags in class files
 *
 */
